package pt.caf_pbs.schooldiskapi.controller;


import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.EnrollDTO;
import pt.caf_pbs.schooldiskapi.dto.LectureDTO;
import pt.caf_pbs.schooldiskapi.dto.StudentDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.*;


@RestController
@RequestMapping("/v1/student")
public class StudentsController {

    @PutMapping("{id}")
    public Student updateStudent(@PathVariable Integer id, @RequestBody StudentDTO studentDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Date date = new Date(studentDTO.getBirthday().getDay(), studentDTO.getBirthday().getMonth(), studentDTO.getBirthday().getYear());
            school.getStudentContainer().update(id, studentDTO.getName(), date);
            FilesOperation.storeSchool(school);
            return school.getStudentContainer().get(id);
        }catch(InvalidDataException e ){
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with "+e.getMessage(), e);
        }
    }

    @PostMapping
    public Student createStudent(@RequestBody StudentDTO studentDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Date date = new Date(studentDTO.getBirthday().getDay(), studentDTO.getBirthday().getMonth(), studentDTO.getBirthday().getYear());
            Student newStudent = new Student(studentDTO.getName(), date);
            school.getStudentContainer().add(newStudent);
            FilesOperation.storeSchool(school);
            return newStudent;
        }catch(DuplicatedDataException | InvalidDataException e ){
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with "+e.getMessage(), e);
        }
    }

    @GetMapping("{id}")
    public Student getStudent(@PathVariable Integer id) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(id);
        if(student != null){
            return student;
        }else{
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Student with id " + id + " found");
        }
    }

    @DeleteMapping("{id}")
    public Student deleteStudent(@PathVariable Integer id) {
        School school = FilesOperation.loadSchool();
        Student student = school.getStudentContainer().get(id);
        if(student != null){
            school.getStudentContainer().remove(id);
            FilesOperation.storeSchool(school);
            return student;
        }else{
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Students with initials " + id + " found");
        }
    }
}
